//
//  IntegrateExternalsToggle.swift
//  CXPatcher
//
//  Created by Italo Mandara on 11/07/2023.
//

import Foundation
import SwiftUI

struct IntegrateGPTKToggle: View {
    @Binding var opts: Opts
    
    var body: some View {
        Toggle(isOn: $opts.copyGptk) {
            VStack(alignment: .leading) {
                HStack(alignment: .center) {
                    Image(systemName: "wand.and.stars")
                    Text(localizedCXPatcherString(forKey: "GPTKToggle"))
                    Spacer()
                }
                if(isVentura) {
                    HStack(alignment: .center) {
                        Image(systemName: "exclamationmark.triangle.fill")
                        Text("MacOS \(String(ProcessInfo().operatingSystemVersion.majorVersion)) \(localizedCXPatcherString(forKey: "unsupported"))")
                    }.foregroundColor(.red)
                }
            }
        }
        .padding(.vertical, 6.0)
        .toggleStyle(.switch)
        .controlSize(/*@START_MENU_TOKEN@*/.mini/*@END_MENU_TOKEN@*/)
        .disabled(
            isVentura
//            || opts.copyXtLibs
        )
        .help(isVentura ? "GPTK is supported on Sonoma only" : "Enables installation of D3dMetal")
    }
}
